/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#pragma once

#include "Context.h"
#include "RemoteCommunication.h"
#include "Transport.h"

#include <chrono>
#include <condition_variable>
#include <cstdint>
#include <map>
#include <memory>
#include <msgpack.hpp>
#include <mutex>
#include <thread>

class RpcRemoteException;
class InputPacket;

class ClientTransport : Context, public Transport
{
private:
	std::map<std::uint32_t, std::unique_ptr<InputPacket>> _received;
	void receiver();
	std::thread receiverThread;
	std::mutex _mutex;
	std::condition_variable _cond;
	RpcRemoteException getException(const msgpack::object_handle& result);

public:
	RemoteCommunication Connection;
	ClientTransport(Context* context);
	~ClientTransport();

	bool Run() override;
	std::unique_ptr<InputPacket> Read(std::uint32_t id, std::chrono::milliseconds timeoutMs) override;
	void checkActive() const override;
	bool IsConnected() const override;
	void StopRunning() noexcept override;
};
